'##############################################################
'Funkmodul RFM12 Test.bas
'
'Ein  Testprogramm fr die Universalplatine RN-MikroFunk
'
'Das Programm demonstriert wie sich Daten per Funk austauschen lassen
'Laden Sie das Programm unverndert in zwei RN-MikroFunk Module
'die mit einem Funkmodul ausgestattet sind.
'Nach dem Start senden und empfangen die Module abwechselnd
'Werden Daten empfangen werden die ber die RS232/USBmodul ausgegeben
'Werden keine Daten empfangen, wird "Kein Datenempfang" ausgegeben.
'Dies ist nur ein Beispielprogramm das fr eigene Zwecke beliebig
'angepasst werden kann
'
'Bezug: www.robotikhardware.de
'Weitere Beispiele auf DVD oder im www.Roboternetz.de und rn-wissen.de
'######################################################################


$programmer = 12                                            'MCS USB  (Zeile weglassen wenn anderer Programmer)
$PROG &HFF,&HFF,&HD9,&HFF 'Diese Anweisung stellt Fusebits ein
$regfile = "m328pdef.dat"
$framesize = 32
$swstack = 32
$hwstack = 64
$crystal = 8000000                                          'Quarzfrequenz
$baud = 9800                                                'Baudrate (bertragungsgeschwindigkeit)
Baud = 9800



Declare Sub Rfm12_init
Declare Sub Rfm12_setfrequenz
Declare Sub Rfm12_empfange
Declare Sub Rfm12_senden
Declare Function Spitransfer(byval Dout As Word) As Word



Config Pind.2 = Input                                       'Int0
Portd.2 = 1                                                 'Pullup
Config Int0 = Falling
Enable Interrupts
Enable Int0
On Int0 Funkirq



Ss Alias Portb.2
Mosi Alias Portb.3
Miso Alias Pinb.4
Sck Alias Portb.5

Config Ss = Output
Config Mosi = Output
Config Sck = Output

Dim Datenbytes As Byte

Dim D As Word
Dim Eingangsdaten(20) As Byte
Dim Ausgabedaten(20) As Byte
Dim N As Byte
Dim Timeout As Word
Dim T As Word
Dim Tt As Word
Dim Frequenz As Single


Ss = 1
Sck = 0
Rfm12_init
Frequenz = 434.150
Rfm12_setfrequenz


Do

    For N = 1 To 10                                         'Datenbytes mit beliebigen Werten fllen
      Ausgabedaten(n) = N
    Next N
    Rfm12_senden

    Waitms 500

    Timeout = 400 + Rnd(1000)
    Rfm12_empfange

    If Datenbytes = 0 Then
     Print "Kein Datenempfang"
    Else
      Print
      Print "Datenbytes:" ; Datenbytes
      For N = 1 To Datenbytes
       Print Eingangsdaten(n);
       Print " ";
      Next N
    End If

    Waitms 700
 Loop











' ************ Hilfsfunktionen zur Kommunikation mit Funkmodul **************
'  (nhere Infos im Datenblatt des Funkmoduls)


' Initialisiere Funkmodul
Sub Rfm12_init
  D = Spitransfer(&H80d7)                                   '433 MHz
 'D = spitransfer(&H80e7)                                         '868 MHz
  D = Spitransfer(&H82d9)
  D = Spitransfer(&Ha67c)                                   '434,15 MHz / 868,3 MHz
  D = Spitransfer(&Hc647)                                   '4.8kbps
  D = Spitransfer(&H94a4)
  D = Spitransfer(&Hc2ac)
  D = Spitransfer(&Hca81)
  D = Spitransfer(&Hc483)
  D = Spitransfer(&H9850)
  D = Spitransfer(&He000)
  D = Spitransfer(&Hc800)
  D = Spitransfer(&Hc000)

  D = Spitransfer(&H0000)
  Waitms 200
End Sub


Sub Rfm12_setfrequenz
  If Frequenz < 800 Then Frequenz = Frequenz * 2
  Frequenz = Frequenz - 860
  D = Frequenz / 0.0050
  If D < 96 Then D = 96
  If D > 3903 Then D = 3903
  D = D + &HA000
  D = Spitransfer(d)
End Sub

Sub Rfm12_empfange
  Tt = Timeout * 10
  D = Spitransfer(&H82c8)
  D = Spitransfer(&Hca83)
  Datenbytes = 0
  For N = 1 To 10
    Ss = 0
    T = 0
    Do
      T = T + 1
      Waitus 100
      If T > Tt Then Goto Nosignal
    Loop Until Miso = 1
    D = Spitransfer(&Hb000)
    Eingangsdaten(n) = D
    Datenbytes = Datenbytes + 1                             'Anzahl der empfangenen Bytes merken
  Next N
Nosignal:
  D = Spitransfer(&H8208)
End Sub

Sub Rfm12_senden
  D = Spitransfer(&H8238)
  Gosub Rfm12_warte
  D = Spitransfer(&Hb8aa)
  Gosub Rfm12_warte
  D = Spitransfer(&Hb8aa)
  Gosub Rfm12_warte
  D = Spitransfer(&Hb8aa)
  Gosub Rfm12_warte
  D = Spitransfer(&Hb82d)
  Gosub Rfm12_warte
  D = Spitransfer(&Hb8d4)
  For N = 1 To 10
    Gosub Rfm12_warte
    D = &HB800 + Ausgabedaten(n)
    D = Spitransfer(d)
  Next N
  Gosub Rfm12_warte
  D = Spitransfer(&Hb8aa)
  Gosub Rfm12_warte
  D = Spitransfer(&Hb8aa)
  Gosub Rfm12_warte
  D = Spitransfer(&H8208)
End Sub



Function Spitransfer(byval Dout As Word) As Word
Local Nspi As Integer
Local Dspi As Integer
Local Dmiso As Word
  Ss = 0
  Dmiso = 0
  For Nspi = 1 To 16
    Dspi = Dout And &H8000
    If Dspi = 0 Then
       Mosi = 0
    Else
       Mosi = 1
    End If
    Dout = Dout * 2
    Dmiso = Dmiso * 2
    Dmiso = Dmiso + Miso
    Sck = 1
    Waitus 5
    Sck = 0
  Next Nspi
  Ss = 1
  Spitransfer = Dmiso
End Function



Rfm12_warte:
Ss = 0
Do
Loop Until Miso = 1
Return

'Wird hier eigentlich nicht bentigt - arbeitet ohne IRQ
Funkirq:
Return